<?php
/**
 * don’t panic it-services
 * User: chris
 * Date: 04.03.20
 * Time: 15:36
 */

$shortopts = "c:v";
$longopts  = array("config:", "version");

$arguments = getopt($shortopts, $longopts);

if (isset($arguments['v']) || isset($arguments['version'])) {
    $version = file_get_contents('VERSION');
    die($version);
}

if (isset($arguments['c'])) {
    $config = $arguments['c'];
} elseif (isset($arguments['config'])) {
    $config = $arguments['config'];
} else {
    $config = 'includes/config.php';
}



$path = dirname(__FILE__);
chdir($path);
require_once($config);
require_once('includes/Idoit.php');
require_once('includes/Zammad.php');
require_once('includes/Logger.php');

$logger = new \ChangRecord\Logger('changeposter.log');
$logger->loglevel = $config['loglevel'];
$logger->write('invoked');

$idoit = new ChangRecord\Idoit($config, $logger);


$zammad = new ChangRecord\Zammad($config);

$unprocessed_tickets = $zammad->get_unprocessed_tickets();

if (is_array($unprocessed_tickets)) {
    $logger->write('found ' . count($unprocessed_tickets) . ' tickets');
    foreach ($unprocessed_tickets as $ticket_id => $unprocessed_ticket) {
        $logger->write('parsing ticket title ' . $unprocessed_ticket);
        preg_match('/.*\[(.+)\].*/', $unprocessed_ticket, $object_titles_string);

        if (isset($object_titles_string[1])) {
            $object_titles = explode(', ', $object_titles_string[1]);
            $logger->write('found object title(s) in ticket title');

            $object_ids = array();

            foreach ($object_titles as $object_title) {
                $logger->write('fetching object ids for ' . $object_title);
                $object_tmp = $idoit->get_ids($object_title);
                $object_ids = array_merge($object_tmp, $object_ids);
            }
            $logger->write('linking ticket ' . $ticket_id . ' with ' );
            $logger->write(print_r($object_ids, true));
            //var_dump($object_ids);

            $zammad_response = $zammad->reference_objects($ticket_id, $object_ids);
            //$logger->write(print_r($zammad_response, true));
        }
    }
}
