<?php
/**
 * don’t panic it-services
 * User: chris
 * Date: 14.03.20
 * Time: 17:30
 */

namespace ChangRecord;


class Idoit {

    private $idoit_url;
    private $idoit_key;
    private $idoit_user;
    private $idoit_pass;
    private $idoit_session = false;
    private $logger;

    public function __construct($config, $logger) {
        if (!$this->idoit_session) {
            $this->idoit_url = $config['idoit_url'];
            $this->idoit_user = $config['idoit_user'];
            $this->idoit_pass = $config['idoit_pass'];
            $this->idoit_key = $config['idoit_key'];
            $this->idoit_session = $this->login();
            $this->logger = $logger;
        }
    }

    private function login(){
        $data = array(
            "jsonrpc" => "2.0",
            "method"  => "idoit.login",
            "id"      => "1",
            "params"  => array(
                "apikey"  => $this->idoit_key
            )
        );
        $result = $this->post($data);
        return $result['result']['session-id'];
    }

    public function version() {
        $data = array(
            "jsonrpc" => "2.0",
            "method"  => "idoit.version",
            "id"      => "1",
            "params"  => array(
                "apikey"  => $this->idoit_key
            )
        );
        return $this->post($data);
    }

    public function get_ids($title) {
        $data = array(
            "jsonrpc" => "2.0",
            "method"  => "cmdb.objects.read",
            "id"      => "1",
            "params"  => array(
                "filter"  => array(
                    "title" => $title
                ),
                "apikey"  => $this->idoit_key
            )
        );
        $results = $this->post($data);
        $results = $results["result"];
        $ids = array();

        foreach ($results as $result) {
            $ids[] = $result["id"];
        }

        return $ids;
    }

    private function post($data) {

        if ($this->idoit_session) {
            $httpheader = array(
                'X-RPC-Auth-Session: ' . $this->idoit_session,
                'Content-Type: application/json'
            );
        } else {
            $httpheader = array(
                'X-RPC-Auth-Username: ' . $this->idoit_user,
                'X-RPC-Auth-Password: ' . $this->idoit_pass,
                'Content-Type: application/json'
            );
        }

        $ch = curl_init($this->idoit_url . '/src/jsonrpc.php');
        curl_setopt_array($ch, array(
            CURLOPT_POST           => true,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER     => $httpheader,
            CURLOPT_POSTFIELDS     => json_encode($data)
        ));

        // Send the request
        $response = curl_exec($ch);

        // Check for errors
        if ($response === false) {
            die(curl_error($ch));
        }

        return json_decode($response, true);

    }


}
