<?php
/**
 * don’t panic it-services
 * User: chris
 * Date: 14.03.20
 * Time: 17:32
 */

namespace ChangRecord;


class Zammad {

    private $zammad_url;
    private $zammad_token;
    private $zammad_group;
    private $zammad_flag;

    public function __construct($config) {
        $this->zammad_url   = $config['zammad_url'];
        $this->zammad_token = $config['zammad_token'];
        $this->zammad_group = $config['zammad_group'];
        $this->zammad_flag  = $config['zammad_flag'];
    }

    public function get_unprocessed_tickets() {
        if ($this->zammad_group) {
            $data = array(
                'query' => $this->zammad_flag . ':false AND group:' . $this->zammad_group
            );
        } else {
            $data = array(
                'query' => $this->zammad_flag . ':false'
            );
        }



        $results = $this->get('tickets', 'search', $data);
        $unprocessed_tickets = array();
        if (isset($results["assets"]["Ticket"]) && is_array($results["assets"]["Ticket"])) {
            foreach ($results["assets"]["Ticket"] as $ticket) {
                $unprocessed_tickets[ $ticket["id"] ] = $ticket["title"];
            }
        }

        return $unprocessed_tickets;

    }

    public function reference_objects($ticket_id, $object_ids) {
        $data = array(
            'preferences' => array(
                'idoit'     => array(
                    'object_ids'    => $object_ids
                )
            ),
            $this->zammad_flag => 1
        );
        
        return $this->put('tickets', $ticket_id, $data);
    }


    private function get($controller, $action, $data){
        $data = http_build_query($data);

        // Setup cURL
        $ch = curl_init($this->zammad_url . '/api/v1/' . $controller . '/' . $action . '/?' . $data);
        curl_setopt_array($ch, array(
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER     => array(
                'Authorization: Token token=' . $this->zammad_token
            )
        ));

        // Send the request
        $response = curl_exec($ch);

        // Check for errors
        if ($response === false) {
            Log::instance()->add(Log::ERROR, curl_error($ch));
        }

        return $responseData = json_decode($response, true);
    }


    private function put($controller, $ticket_id, $data){

        // Setup cURL
        $ch = curl_init($this->zammad_url . '/api/v1/' . $controller . '/' . $ticket_id);
        curl_setopt_array($ch, array(
            CURLOPT_CUSTOMREQUEST  => "PUT",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER     => array(
                'Authorization: Token token=' . $this->zammad_token,
                'Content-Type: application/json'
            ),
            CURLOPT_POSTFIELDS     => json_encode($data)
        ));

        // Send the request
        $response = curl_exec($ch);

        // Check for errors
        if ($response === false) {
            die(curl_error($ch));
        } else {
            return $responseData = json_decode($response, true);
        }
    }

}
